#!/bin/tcsh

set path = ($path /data/brutus_data0/freeware/afni)
echo $path

#foreach subj (001)
foreach subj (s001 s002)

echo '***************' ${subj} '*************** '

cd /data/.../FC/SB_rsFC/RSN/Data_subj/${subj}/

#================  auditory network (AN)  === *** =========================
3dmaskave -quiet -mask a1+tlrc 	Corr_${subj}_a2_Z+tlrc 		> ${subj}_a1a2.1D
3dmaskave -quiet -mask a2+tlrc 	Corr_${subj}_a1_Z+tlrc 		> ${subj}_a2a1.1D

#==================   AttN     ==============================================
3dmaskave -quiet -mask f1+tlrc 	Corr_${subj}_p1_Z+tlrc 		> ${subj}_f1p1.1D
3dmaskave -quiet -mask p1+tlrc 	Corr_${subj}_f1_Z+tlrc 		> ${subj}_p1f1.1D
3dmaskave -quiet -mask f2+tlrc 	Corr_${subj}_p2_Z+tlrc 		> ${subj}_f2p2.1D
3dmaskave -quiet -mask p2+tlrc  Corr_${subj}_f2_Z+tlrc      > ${subj}_p2f2.1D

#====================   DMN   ======= *** ===================================
3dmaskave -quiet -mask d1+tlrc 	Corr_${subj}_d2_Z+tlrc 		> ${subj}_d1d2.1D
3dmaskave -quiet -mask d2+tlrc 	Corr_${subj}_d1_Z+tlrc 		> ${subj}_d2d1.1D
3dmaskave -quiet -mask d2+tlrc 	Corr_${subj}_d3_Z+tlrc 		> ${subj}_d2d3.1D
3dmaskave -quiet -mask d3+tlrc  Corr_${subj}_d2_Z+tlrc      > ${subj}_d3d2.1D
3dmaskave -quiet -mask d3+tlrc  Corr_${subj}_d1_Z+tlrc      > ${subj}_d3d1.1D
3dmaskave -quiet -mask d1+tlrc  Corr_${subj}_d3_Z+tlrc      > ${subj}_d1d3.1D

#====================   ECN   = *** =========================================
3dmaskave -quiet -mask e1+tlrc 	Corr_${subj}_e2_Z+tlrc 		> ${subj}_e1e2.1D
3dmaskave -quiet -mask e2+tlrc 	Corr_${subj}_e1_Z+tlrc 		> ${subj}_e2e1.1D

#====================   FPN    = *** ========================================
3dmaskave -quiet -mask f3+tlrc 	Corr_${subj}_p3_Z+tlrc 		> ${subj}_f3p3.1D
3dmaskave -quiet -mask p3+tlrc 	Corr_${subj}_f3_Z+tlrc 		> ${subj}_p3f3.1D
3dmaskave -quiet -mask f4+tlrc 	Corr_${subj}_p4_Z+tlrc 		> ${subj}_f4p4.1D
3dmaskave -quiet -mask p4+tlrc  Corr_${subj}_f4_Z+tlrc      > ${subj}_p4f4.1D

#====================   SN  ======= *** =====================================
3dmaskave -quiet -mask s1+tlrc 	Corr_${subj}_s2_Z+tlrc 		> ${subj}_s1s2.1D
3dmaskave -quiet -mask s2+tlrc 	Corr_${subj}_s1_Z+tlrc 		> ${subj}_s2s1.1D
3dmaskave -quiet -mask s2+tlrc 	Corr_${subj}_s3_Z+tlrc 		> ${subj}_s2s3.1D
3dmaskave -quiet -mask s3+tlrc  Corr_${subj}_s2_Z+tlrc      > ${subj}_s3s2.1D
3dmaskave -quiet -mask s3+tlrc  Corr_${subj}_s1_Z+tlrc      > ${subj}_s3s1.1D
3dmaskave -quiet -mask s1+tlrc  Corr_${subj}_s3_Z+tlrc      > ${subj}_s1s3.1D

#=================    SMN    ====== *** =====================================
3dmaskave -quiet -mask m1+tlrc 	Corr_${subj}_m2_Z+tlrc 		> ${subj}_m1m2.1D
3dmaskave -quiet -mask m2+tlrc 	Corr_${subj}_m1_Z+tlrc 		> ${subj}_m2m1.1D
3dmaskave -quiet -mask m2+tlrc 	Corr_${subj}_m3_Z+tlrc 		> ${subj}_m2m3.1D
3dmaskave -quiet -mask m3+tlrc  Corr_${subj}_m2_Z+tlrc      > ${subj}_m3m2.1D
3dmaskave -quiet -mask m3+tlrc  Corr_${subj}_m1_Z+tlrc      > ${subj}_m3m1.1D
3dmaskave -quiet -mask m1+tlrc  Corr_${subj}_m3_Z+tlrc      > ${subj}_m1m3.1D

#====================     VN      === *** ===================================
3dmaskave -quiet -mask v1+tlrc 	Corr_${subj}_v2_Z+tlrc 		> ${subj}_v1v2.1D
3dmaskave -quiet -mask v2+tlrc 	Corr_${subj}_v1_Z+tlrc 		> ${subj}_v2v1.1D
3dmaskave -quiet -mask v2+tlrc 	Corr_${subj}_v3_Z+tlrc 		> ${subj}_v2v3.1D
3dmaskave -quiet -mask v3+tlrc 	Corr_${subj}_v2_Z+tlrc 		> ${subj}_v3v2.1D
3dmaskave -quiet -mask v3+tlrc 	Corr_${subj}_v1_Z+tlrc 		> ${subj}_v3v1.1D
3dmaskave -quiet -mask v1+tlrc 	Corr_${subj}_v3_Z+tlrc 		> ${subj}_v1v3.1D

end




















